We will pass a GPU through to a proxmox container and utilize it for video transcoding.

In PVE Host shell

`uname -r`

- Install headers
`apt install pve-headers`
- Blacklist nouveau
`nano /etc/modprobe.d/blacklist.conf`
- Add lines
`blacklist nouveau`
- Update Initramfs
`update-initramfs -u`
- Reboot!

- Install dependencies
`apt install build-essential`
- Download driver (https://www.nvidia.com/Download/index.aspx?lang=en-us)
`wget {YOUR-DRIVER-URL)`
- Make the driver file executable
`chmod +x {YOUR-DRIVER-FILE}`
- Install the driver
`./{YOUR-DRIVER-FILE}`
- Make sure the driver loads when restarted
`nano /etc/modules-load.d/modules.conf`
- Add lines
```
nvidia
nvidia-modeset
nvidia_uvm
```
- Update Initramfs
`update-initramfs -u`
- Create udev rules
`nano /etc/udev/rules.d/70-nvidia.rules`
- Add lines
```
KERNEL=="nvidia", RUN+="/bin/bash -c '/usr/bin/nvidia-smi -L && /bin/chmod 666 /dev/nvidia*'"
KERNEL=="nvidia_modeset", RUN+="/bin/bash -c '/usr/bin/nvidia-modprobe -c0 -m && /bin/chmod 666 /dev/nvidia-modeset*'"
KERNEL=="nvidia_uvm", RUN+="/bin/bash -c '/usr/bin/nvidia-modprobe -c0 -u && /bin/chmod 666 /dev/nvidia-uvm*'"
```
- Reboot!

- Check if the driver is running
`nvidia-smi`
- Edit the container conf you want to passthrough to
`nano /etc/pve/lxc/{YOUR-LXC-ID}.conf`
- Note the output of this
`ls -l /dev/nv*`
- Add these lines but make sure the path (numbers) are correct
```
#Allow cgroup access
lxc.cgroup2.devices.allow = c 195:0 rw
lxc.cgroup2.devices.allow = c 195:255 rw
lxc.cgroup2.devices.allow = c 195:254 rw
lxc.cgroup2.devices.allow = c 509:0 rw
lxc.cgroup2.devices.allow = c 509:1 rw
lxc.cgroup2.devices.allow = c 10:144 rw

#Pass through device files
lxc.mount.entry = /dev/nvidia0 dev/nvidia0 none bind,optional,create=file
lxc.mount.entry = /dev/nvidiactl dev/nvidiactl none bind,optional,create=file
lxc.mount.entry = /dev/nvidia-modeset dev/nvidia-modeset none bind,optional,create=file
lxc.mount.entry = /dev/nvidia-uvm dev/nvidia-uvm none bind,optional,create=file
lxc.mount.entry = /dev/nvidia-uvm-tools dev/nvidia-uvm-tools none bind,optional,create=file
lxc.mount.entry = /dev/nvram dev/nvram none bind,optional,create=file
```
- Start the container
- In LXC shell
`apt update && apt upgrade -y`
- Download driver (https://www.nvidia.com/Download/index.aspx?lang=en-us)
`wget {YOUR-DRIVER-URL)`
- Make the driver file executable
`chmod +x {YOUR-DRIVER-FILE}`
- Install the driver
`./{YOUR-DRIVER-FILE} --no-kernel-module`
- Reboot!
- See if the driver is working
`nvidia-smi`
## Now you can install Jellyfin and use your nVidia GPU for transcoding.

Video tutorial: [https://www.youtube.com/watch?v=-Us8KPOhOCY](https://www.youtube.com/watch?v=-Us8KPOhOCY)