# NVIDIA GPU Passthrough for Video Transcoding in LXC (Proxmox)

### 1. Check Kernel Version on PVE Host
Open the PVE Host shell and run:
```sh
uname -r
```

### 2. Install Headers
Search for the available PVE headers:
```sh
apt-cache search pve-header
```
Install the appropriate headers:
```sh
apt install pve-headers-*.*.*-*-pve
```

### 3. Blacklist Nouveau
Edit the blacklist configuration file:
```sh
nano /etc/modprobe.d/blacklist.conf
```
Add the following line:
```
blacklist nouveau
```
Update the initial RAM filesystem:
```sh
update-initramfs -u
```
Reboot the system:
```sh
reboot
```

### 4. Install Dependencies
Install build essentials:
```sh
apt install build-essential
```

### 5. Download and Install Nvidia Drivers
Download the Nvidia drivers from [nvidia.com/Download/index.aspx](https://www.nvidia.com/Download/index.aspx):
```sh
wget (YOUR_DRIVER_URL)
```
Make the driver file executable:
```sh
chmod +x (YOUR_DRIVER_FILE).run
```
Install the drivers:
```sh
./(YOUR_DRIVER_FILE).run
```

### 6. Ensure Drivers Load on Restart
Edit the modules load configuration:
```sh
nano /etc/modules-load.d/modules.conf
```
Add the following lines:
```
# Nvidia modules
nvidia
nvidia-modeset
nvidia_uvm
```
Update the initial RAM filesystem:
```sh
update-initramfs -u
```

### 7. Create Udev Rules
Create a new udev rules file:
```sh
nano /etc/udev/rules.d/70-nvidia.rules
```
Add the following lines:
```
KERNEL=="nvidia", RUN+="/bin/bash -c '/usr/bin/nvidia-smi -L && /bin/chmod 666 /dev/nvidia*'"
KERNEL=="nvidia_modeset", RUN+="/bin/bash -c '/usr/bin/nvidia-modprobe -c0 -m && /bin/chmod 666 /dev/nvidia-modeset*'"
KERNEL=="nvidia_uvm", RUN+="/bin/bash -c '/usr/bin/nvidia-modprobe -c0 -u && /bin/chmod 666 /dev/nvidia-uvm*'"
```
Reboot the system:
```sh
reboot
```

### 8. Verify Driver Installation
Check that the drivers are running:
```sh
nvidia-smi
```

### 9. Edit Container Configuration for GPU Passthrough
Edit the configuration file of the container:
```sh
nano /etc/pve/lxc/(YOUR_CONTAINER_ID).conf
```
Add the following lines, ensuring the paths (numbers) are correct:
```
# Allow cgroup access
lxc.cgroup2.devices.allow = c 195:0 rw
lxc.cgroup2.devices.allow = c 195:255 rw
lxc.cgroup2.devices.allow = c 195:254 rw
lxc.cgroup2.devices.allow = c 509:0 rw
lxc.cgroup2.devices.allow = c 509:1 rw
lxc.cgroup2.devices.allow = c 10:144 rw

# Pass through device files
lxc.mount.entry = /dev/nvidia0 dev/nvidia0 none bind,optional,create=file
lxc.mount.entry = /dev/nvidiactl dev/nvidiactl none bind,optional,create=file
lxc.mount.entry = /dev/nvidia-modeset dev/nvidia-modeset none bind,optional,create=file
lxc.mount.entry = /dev/nvidia-uvm dev/nvidia-uvm none bind,optional,create=file
lxc.mount.entry = /dev/nvidia-uvm-tools dev/nvidia-uvm-tools none bind,optional,create=file
lxc.mount.entry = /dev/nvram dev/nvram none bind,optional,create=file
```

### 10. Set Up GPU in the Container
Start the container and update:
```sh
apt update && apt upgrade -y
```
Download the Nvidia drivers inside the container:
```sh
wget (YOUR_DRIVER_URL)
```
Make the driver file executable:
```sh
chmod +x (YOUR_DRIVER_FILE).run
```
Run the driver file without the kernel module:
```sh
./(YOUR_DRIVER_FILE).run --no-kernel-module
```
Reboot the container:
```sh
reboot
```
Verify the setup:
```sh
nvidia-smi
```

#### Now, your Proxmox container should be set up for GPU passthrough and ready for video transcoding tasks.
##### Source: LoRes DIY [youtu.be/-Us8KPOhOCY](https://youtu.be/-Us8KPOhOCY)