# Resolving iDRAC8 Access Error 400 — Bad Request

## Issue
After installing a new Dell server with iDRAC8 and assigning an IP address using the BIOS/Console interface, attempting to connect to iDRAC via `https://idrac.mydomain.com` results in the following error:

```
Access Error: 400 — Bad Request
```

However, accessing iDRAC via `https://<iDRAC_IP>` works correctly.

## Solution
### Step 1: Update DNS Settings
1. Connect to the iDRAC using its IP address.
2. Navigate to the **iDRAC Settings**:
   - On the left side, select **Network** under iDRAC settings.
3. Update the DNS settings:
   - In the **Common Settings** section (on the right side):
     - Set the **DNS iDRAC Name** to the desired hostname for the iDRAC. (idrac)
     - Set the **Static DNS Domain Name** to the domain name of your network. (mydomain.com)
4. **Important**: Scroll down and click the **Apply** button to save changes.

### Step 2: Install iDRAC Tools or OMSA
The next steps require the Dell iDRAC Tools or OMSA (OpenManage Server Administrator) to be installed. If the operating system is not yet installed on the server, install these tools on another Dell server within the same network.

#### Option A: iDRAC Tools Installed on the Current Server
Run the following commands:
```bash
racadm sslresetcfg
racadm sslcertview -t 1  # Verify the FQDN is now in the certificate
racadm racreset          # Reboot the iDRAC for the changes to take effect
```

#### Option B: iDRAC Tools Installed on Another Server
Run the following commands from the other server:
```bash
racadm -r <iDRAC_IP> -u root -p <RootPassword> sslresetcfg
racadm -r <iDRAC_IP> -u root -p <RootPassword> sslcertview -t 1  # Verify the FQDN is now in the certificate
racadm -r <iDRAC_IP> -u root -p <RootPassword> racreset          # Reboot the iDRAC for the changes to take effect
```

### Notes
- Ensure the iDRAC DNS settings are correctly configured to match your network environment.
- Use a secure password for the `root` user when executing commands.

By following these steps, the iDRAC web interface should now be accessible using the fully qualified domain name (FQDN), resolving the "Access Error: 400 — Bad Request" issue.

