# PMP Vizsga

## 1 - 2.1 Sorozatszámítás

Bemenet:

- x − T tömb
- n − egész (tömb mérete)

Kimenet:

- érték - T

```pseudo
1: függvény Sorozatszámítás(x : T tömb, n : egész)
2: érték ← érték0
3: ciklus i ← 1-től n-ig
4: érték ← érték ⊕ x[i]
5: ciklus vége
6: vissza érték
7: függvény vége
```

## 2 - 2.2 Eldöntés

Bemenet:

- x − T tömb
- n − egész (tömb mérete)
- P − logikai (tulajdonság)

Kimenet:

- van − logikai

```psuedo
1: függvény Eldöntés(x : T tömb, n : egész, P : logikai)
2: i ← 1
3: ciklus amíg (i ≤ n) ∧ ¬P (x[i])
4: i ← i + 1
5: ciklus vége
6: van ← (i ≤ n)
7: vissza van
8: függvény vége
```

## 3 - 2.3 Módosított eldöntés

Bemenet:

- x − T tömb
- n − egész (tömb mérete)
- P − logikai (tulajdonság)

Kimenet:

- van − logikai

```pseudo
1: függvény Eldöntés_Minden(x : T tömb, n : egész, P : logikai)
2: i ← 1
3: ciklus amíg (i ≤ n) ∧ P (x[i])
4: i ← i + 1
5: ciklus vége
6: van ← (i > n)
7: vissza van
8: függvény vége
```

## 4 - 2.5 Növekvő rendezettség vizsgálata

Bemenet:

- x − T tömb
- n − egész; ahol T összehasonlítható

Kimenet:

- rendezett − logikai

```pseudo
1: függvény Rendezett_E(x : T tömb, n : egész)
2: i ← 1
3: ciklus amíg (i ≤ n − 1) ∧ (x[i] ≤ x[i + 1])
4: i ← i + 1
5: ciklus vége
6: rendezett ← (i > n − 1)
7: vissza rendezett
8: függvény vége
```

## 5 - 2.7 Lineáris keresés

Bemenet:

- x − T tömb
- n − egész
- P − logikai


Kimenet:

- van − logikai
- idx − egész

```pseudo
1: függvény LineárisKeresés(x : T tömb, n : egész, P : logikai)
2: i ← 1
3: ciklus amíg (i ≤ n) ∧ ¬P (x[i])
4: i ← i + 1
5: ciklus vége
6: van ← (i ≤ n)
7: ha van akkor
8: idx ← i
9: vissza (van, idx)
10: különben
11: vissza van
12: elágazás vége
13: függvény vége
```

## 6 - 2.8 Lineáris keresés (konkrét érték keresése)

Bemenet:

- x − T tömb
- n − egész
- érték − T

Kimenet:

- van − logikai
- idx − egész

```pseudo
1: függvény LineárisKeresés(x : T tömb, n : egész, érték : T)
2: i ← 1
3: ciklus amíg (i ≤ n) ∧ (x[i] != érték)
4: i ← i + 1
5: ciklus vége
6: van ← (i ≤ n)
7: ha van akkor
8: idx ← i
9: vissza (van, idx)
10: különben
11: vissza van
12: elágazás vége
13: függvény vége
```

## 7 - 2.9 Megszámlálás

Bemenet:

- x − T tömb
- n − egész (tömb mérete)
- P − logikai (tulajdonság)

Kimenet:

- db − egész (darabszám)

```pseudo
1: függvény Megszámlálás(x : T tömb, n : egész, P : logikai)
2: db ← 0
3: ciklus i ← 1-től n-ig
4: ha P (x[i]) akkor
5: db ← db + 1
6: elágazás vége
7: ciklus vége
8: vissza db
9: függvény vége
```

## 8 - 2.10 Maximumkiválasztás

Bemenet:

- x − T tömb
- n − egész (tömb mérete); ahol T összehasonlítható

Kimenet:

- max − egész

```pseudo
1: függvény Maximumkiválasztás(x : T tömb, n : egész)
2: max ← 1
3: ciklus i ← 2-től n-ig
4: ha x[i] > x[max] akkor
5: max ← i
6: elágazás vége
7: ciklus vége
8: vissza max
9: függvény vége
```

## 9 - 2.11 Másolás

Bemenet:

- x − T tömb
- n − egész (tömb mérete)
- f − művelet

Kimenet:

- y − T tömb

```pseudo
1: függvény Másolás(x : T tömb, n : egész, f : művelet)
2: y ← Létrehoz(T)[n]
3: ciklus i ← 1-től n-ig
4: y[i] ← f (x[i])
5: ciklus vége
6: vissza y
7: függvény vége
```

## 10 - 2.12 Kiválogatás

Bemenet:

- x − T tömb
- n − egész (tömb mérete)
- P − logikai

Kimenet:

- y − T tömb
- db − egész

```pseudo
1: függvény Kiválogatás(x : T tömb, n : egész, P : logikai)
2: y ← Létrehoz(T)[n]
3: db ← 0
4: ciklus i ← 1-től n-ig
5: ha P (x[i]) akkor
6: db ← db + 1
7: y[db] ← x[i]
8: elágazás vége
9: ciklus vége
10: vissza (y, db)
11: függvény vége
```

## 11 - 2.13 Kiválogatás az eredeti tömbben

Bemenet:

- x − T tömb
- n − egész (tömb mérete)
- P − logikai

Kimenet:

- x − T tömb
- db − egész

```pseudo
1: függvény KiválogatásHelyben(címszerint x : T tömb, n : egész, P : logikai)
2: db ← 0
3: ciklus i ← 1-től n-ig
4: ha P (x[i]) akkor
5: db ← db + 1
6: x[db] ← x[i]
7: elágazás vége
8: ciklus vége
9: vissza db
10: függvény vége
```

## 12 - 2.14 Kiválogatás az eredeti tömbben az eredeti elemek megtartásával

Bemenet:

- x − T tömb
- n − egész (tömb mérete)
- P − logikai

Kimenet:

- x − T tömb
- db − egész

```pseudo
1: függvény Kiválogatás(címszerint x : T tömb, n : egész, P : logikai)
2: db ← 0
3: ciklus i ← 1-től n-ig
4: ha P (x[i]) akkor
5: db ← db + 1
6: x[db] ↔ x[i]
7: elágazás vége
8: ciklus vége
9: vissza db
10: függvény vége
```

## 13 - 2.15 Szétválogatás

Bemenet:

- x − T tömb
- n − egész (tömb mérete)
- P − logikai

Kimenet:

- y1 − T tömb
- db1 − egész
- y2 − T tömb
- db2 − egész

```pseudo
1: függvény Szétválogatás(x : T tömb, n : egész, P : logikai)
2: y1 ← Létrehoz(T)[n]
3: y2 ← Létrehoz(T)[n]
4: db1 ← 0
5: db2 ← 0
6: ciklus i ← 1-től n-ig
7: ha P (x[i]) akkor
8: db1 ← db1 + 1
9: y1[db1] ← x[i]
10: különben
11: db2 ← db2 + 1
12: y2[db2] ← x[i]
13: elágazás vége
14: ciklus vége
15: vissza(y1, db1, y2, db2)
16: függvény vége
```

## 14 - 2.16 Szétválogatás egyetlen új kimeneti tömbbe

Bemenet:

- x − T tömb
- n − egész (tömb mérete)
- P − logikai

Kimenet:

- y − T tömb
- db − egész

```pseudo
1: függvény Szétválogatás(x : T tömb, n : egész, P : logikai)
2: y ← Létrehoz(T)[n]
3: db ← 0
4: jobb ← n + 1
5: ciklus i ← 1-től n-ig
6: ha P (x[i]) akkor
7: db ← db + 1
8: y[db] ← x[i]
9: különben
10: jobb ← jobb − 1
11: y[jobb] ← x[i]
12: elágazás vége
13: ciklus vége
14: vissza(y, db)
15: függvény vége
```

## 15 - 3.3 Minimumkiválasztásos rendezés

Bemenet:

- x − T tömb
- n − egész (tömb mérete); ahol T összehasonlítható

Kimenet:

- x − T rendezett tömb

```pseudo
1: eljárás MinimumkiválasztásosRendezés(címszerint x : T tömb, n : egész)
2: ciklus i ← 1-től (n − 1)-ig
3: min ← i
4: ciklus j ← (i + 1)-től n-ig
5: ha x[min] > x[j] akkor
6: min ← j
7: elágazás vége
8: ciklus vége
9: x[i] ↔ x[min]
10: ciklus vége
11: eljárás vége
```

## 16 - 3.4 Buborékrendezés

Bemenet:

- x − T tömb
- n − egész (tömb mérete); ahol T összehasonlítható

Kimenet:

- x − T rendezett tömb

```pseudo
1: eljárás BuborékRendezés(címszerint x : T tömb, n : egész)
2: ciklus i ← n-től 2-ig
3: ciklus j ← 1-től (i − 1)-ig
4: ha x[j] > x[j + 1] akkor
5: x[j] ↔ x[j + 1]
6: elágazás vége
7: ciklus vége
8: ciklus vége
9: eljárás vége
```

## 17 - 3.5 Javított buborékrendezés

Bemenet:

- x − T tömb
- n − egész (tömb mérete); ahol T összehasonlítható

Kimenet:

- x − T rendezett tömb

```pseudo
1: eljárás JavítottBuborékRendezés(címszerint x : T tömb, n : egész)
2: i ← n
3: ciklus amíg i ≥ 2
4: idx ← 0
5: ciklus j ← 1-től (i − 1)-ig
6: ha x[j] > x[j + 1] akkor
7: x[j] ↔ x[j + 1]
8: idx ← j
9: elágazás vége
10: ciklus vége
11: i ← idx
12: ciklus vége
13: eljárás vége
```

## 18 - 3.6 Beillesztéses rendezés

Bemenet:

- x − T tömb
- n − egész (tömb mérete); ahol T összehasonlítható

Kimenet:

- x − T rendezett tömb

```pseudo
1: eljárás BeillesztésesRendezés(címszerint x : T tömb, n : egész)
2: ciklus i ← 2-től n-ig
3: j ← i − 1
4: ciklus amíg (j > 0) ∧ (x[j] > x[j + 1])
5: x[j] ↔ x[j + 1]
6: j ← j − 1
7: ciklus vége
8: ciklus vége
9: eljárás vége
```

## 19 - 3.7 Javított beillesztéses rendezés

Bemenet:

- x − T tömb
- n − egész (tömb mérete); ahol T összehasonlítható

Kimenet:

- x − T rendezett tömb

```pseudo
1: eljárás JavítottBeillesztésesRendezés(címszerint x : T tömb, n : egész)
2: ciklus i ← 2-től n-ig
3: j ← i − 1
4: segéd ← x[i]
5: ciklus amíg (j > 0) ∧ (x[j] > segéd)
6: x[j + 1] ← x[j]
7: j ← j − 1
8: ciklus vége
9: x[j + 1] ← segéd
10: ciklus vége
11: eljárás vége
```

## 20 - 4.1 Faktoriális iteratív kiszámítása

Bemenet:

- N − egész (természetes szám)

Kimenet:

- érték − egész

```pseudo
1: függvény FaktoriálisIteratív(N : egész)
2: érték ← 1
3: ciklus i ← 2-től N -ig
4: érték ← érték · i
5: ciklus vége
6: vissza érték
7: függvény vége
```

## 21 - 4.2 Faktoriális rekurzív kiszámítása

Bemenet:

- N − egész (természetes szám)

Kimenet:

- N faktoriálisa

```pseudo
1: függvény FaktoriálisRekurzív(N : egész)
2: ha N = 0 akkor
3: vissza 1
4: különben
5: vissza N · FaktoriálisRekurzív(N − 1)
6: elágazás vége
7: függvény vége
```

## 22 - 4.3 Fibonacci sorozat N -edik elemének rekurzív meghatározása

Bemenet:

- N − egész

Kimenet:

- N -edik Fibonacci szám

```pseudo
1: függvény FibonacciRekurzív(N : egész)
2: ha N ≤ 1 akkor
3: vissza 1
4: különben
5: vissza FibonacciRekurzív(N − 2) + FibonacciRekurzív(N − 1)
6: elágazás vége
7: függvény vége
```

## 23 - 4.4 Fibonacci sorozat N-edik elemének iteratív meghatározása

Bemenet:

- N − egész

Kimenet:

- aktuális − egész

```psuedo
1: függvény FibonacciIteratív(N : egész)
2: aktuális ← 1
3: előző ← 1
4: ciklus i ← 1-től (N − 1)-ig
5: átmeneti ← aktuális + előző
6: előző ← aktuális
7: aktuális ← átmeneti
8: ciklus vége
9: vissza aktuális
10: függvény vége
```

## 24 - 4.7 aN rekurzív meghatározása

Bemenet:

- a − szám
- N − egész

Kimenet:

- aN értéke

```pseudo
1: függvény HatványRekurzív(a : szám, N : egész)
2: ha N = 1 akkor
3: vissza a
4: különben
5: vissza a · HatványRekurzív(a, N − 1)
6: elágazás vége
7: függvény vége
```

## 25 - 4.8 aN felezéses elvű rekurzív meghatározása

Bemenet:

- a − szám
- N − egész
Kimenet:

- aN értéke

```pseudo
1: függvény HatványFelező(a : szám, N : egész)
2: ha N = 1 akkor
3: vissza a
4: különben
5: ha N páros akkor
6: segéd ← HatványFelező (a, N/2)
7: vissza segéd · segéd
8: különben
9: segéd ← HatványFelező (a, (N−1)/2)
10: vissza a · segéd · segéd
11: elágazás vége
12: elágazás vége
13: függvény vége
```

## 26 - 4.9 Hanoi tornyai

Bemenet:

- N − egész
- forrás − rúd
- cél − rúd
- segéd − rúd

```pseudo
1: eljárás Hanoi(N : egész, forrás : rúd, cél : rúd, segéd : rúd)
2: ha N = 1 akkor
3: Mozgat(1, forrás, cél)
4: különben
5: Hanoi(N − 1, forrás, segéd, cél)
6: Mozgat(N, forrás, cél)
7: Hanoi(N − 1, segéd, cél, forrás)
8: elágazás vége
9: eljárás vége
```
