# VPN - a Very Precarious Narrative

[source](https://overengineer.dev/blog/2019/04/08/very-precarious-narrative.html)

I just watched a _great_ YouTube video, touching technical, political, and philosophical questions around the whole “who controls the algorithm” topic, from one of those multi-million subscriber channels, spending lots and lots of time and resources on researching and producing. The video was perfect, but the end did upset me slightly. In the end, the sponsoring message was read, and the sponsor was one of those VPN companies, with their usual marketing lingo. You surely know what I am talking about, but let me quote the sponsoring message here for context:

> Your internet connection, right now, is broadcasting your IP address, which is the way people track you online. Check this out [shows a screencap of a website displaying the IP and GeoLocation information], when I go to this website, it tests everything that my internet connection is leaking. You can see my IP address, but you can also see where I am. Your internet connection is doing this right now. Here is how [VPN company] works: It is a Virtual Private Network, you turn it on with one click. My internet traffic is now encrypted, and going through [VPN company]s servers located throughout the world, so people can no longer figure out where I am located. I protect myself online with [VPN company]. […] There is a 30-day money back guarantee which I am confident you are not going to use, because I feel comforted knowing that my personal information is protected on the internet.

Here is another one, from a different channel:

>With all the recent news about online security breaches, it is hard not to worry about where my data goes. Make an online purchase or simply accessing your email puts your private information at risk. You are being tracked online all the time by social media sites, marketing companies, and mobile internet providers. That is why you need to take your internet privacy back right now. Use [VPN company]! [VPN company] has the easiest apps that run seamlessly in the background of any computer, phone, and tablet. Turning on [VPN company] protection only takes one click. I am going to tell you what takes more than one click: getting your identity and data back after it’s been lost. Try getting back the money from your stolen credit cards. Do one click now. [VPN company] secures and anoymizes your internet browsing by encrypting your data and hiding your public IP address.

The popularity of those services and the way they are recommended and promoted is bad. So bad that I feel impelled to write this article on it, to explain two problematic points. Those are:
1. In most circumstances, **VPNs do very little to enhance your data security or privacy** unless paired with other changes.
2. Acting as they do, and **promoting commercial VPN providers** as a solution to potential issues **does more harm than good**.
Just stick around for a bit, and I will explain everything. Before I start, though, let me clarify that I am writing this post with non-technical, but curious people in mind. This means that I will be using simplified terms and sometimes generalize a bit. However, I can assure you that all information is still very accurate. Sometimes, using technical words is necessary to avoid this post becoming inaccurate. If you do not understand something, just read on, the next paragraph might be more apparent.

## What a VPN is, and what it is not.
> […] another worrying aspect of today’s market of VPN services is the large misinformation end users are exposed to, which makes it hard for them to properly tell apart vague and bold claims typical of product advertisement campaigns with actual facts.
> 
> - _a [paper published in 2015](http://web.archive.org/web/20190814224309/https://www.degruyter.com/downloadpdf/j/popets.2015.1.issue-1/popets-2015-0006/popets-2015-0006.pdf)_.

To start, [Wikipedia](https://en.wikipedia.org/wiki/Virtual_private_network) has a very nice summary of what a VPN is:
> A virtual private network (VPN) extends a private network across a public network, and enables users to send and receive data across shared or public networks as if their computing devices were directly connected to the private network.

A VPN is a _tunnel_ connecting two different networks. You throw traffic into one end of the tunnel, and it will come out somewhere else, even if the destination might not be reachable on the public internet. VPNs are popular in company environments: Imagine a large company running their servers with private sale data on them. The company does not want those servers to be reachable via the internet for security reasons, but at the same time, salespeople need to be able to access those datasets, even if they are on the road. The salesperson can use the company’s VPN to “move their laptop into the company network”, without the need to physically be there, so they have access to that information. In addition, network traffic sent over VPNs is generally encrypted, so even if the salesperson is using a maybe insecure network, the data is probably safe, if everything is configured correctly.

The VPNs that get advertised at the end of YouTube videos are different. They are not used to access protected, internal infrastructure. Instead, they are used to tunnel _all_ network traffic into a datacenter you neither know nor can control in any way. To understand why this might be a bad idea and is absolutely not necessary in most cases, let’s look at the marketing claims.

## “Your IP is used for tracking and leaks private information. You should hide it.”

One thing that most VPN advertisements have in common is some babble around IP addresses. Providers claim that your IP address leaks tons of private information, even your physical location, and they also claim that IP addresses are used for tracking. I call that fearmongering and deliberate misinformation.

![vpn-check](https://user-images.githubusercontent.com/53189968/245770007-bd68e231-c2e8-4442-9648-e6e5aef37c64.jpg)

I am sure you have seen notices like these on VPN provider’s websites before. They claim that your IP can be used to track you, and they even show a map of where you are located to make it look scarier.

Before I address those two things, let me say something more generic. Notice how both sites show my IP, claim that my connection is “unprotected”, and one is even showing a map? Well. In reality, I am actually _using a VPN_ in those screenshots, I just happened to use [ProtonVPN](https://protonvpn.com/) for this example, so I should be protected very well, right? How come they claim I am unprotected?

That is because those “tests” do not do anything useful. The only check these things are doing is a simple “is the user currently connected via one of our IPs, and thus is using our VPN? If yes, say the user is protected, otherwise, act like the world is on fire”. Not very productive.

### IP addresses for user identification

One of the sponsor messages I quoted earlier explicitly claims that IP addresses are how you “are being tracked online all the time by social media sites and marketing companies”. But is that so? We all know that Facebook is pretty big in the whole “tracking people” business, so if you have an active subscription at one of those VPN providers and a Facebook account, let’s do a test together!

1. Open a new Private Window/Incognito Window in your favorite browser.
2. In that window, open two tabs: Facebook, and the “What is my IP?” page of your VPN provider, like [this one from ExpressVPN](https://www.expressvpn.com/what-is-my-ip).
3. Log in to your Facebook account.
4. With the VPN disabled, verify that the “test” site shows “you are unprotected”, like in my screenshots above.
5. Connect to your VPN. Refresh the VPN test page, which should now say that your IP is hidden and your connection is protected. Right?
6. Now, switch over to the Facebook tab, and hit reload.

So, what happened? Did Facebook forget who you are, and boot you back out to the login form? No, of course not. Even though your IP address changed, Facebook still knew _exactly_ who you are. So do marketing companies and other tracking parties.

The reality here is that your IP address is only a tiny piece of your trackable profile and a pretty unreliable one as such. Tracking companies are interested in tracking _you_, not a specific device or a specific browsing session. Your IP changes all the time, take your mobile phone as an example: You may be connected to your home WiFi, to your mobile connection, the network at work, … and you will have a different IP in each network. Moreover, these IPs are not even unique to you in most cases: most mobile phone networks share their public IPs to hundreds, sometimes thousands of mobile phones in a process called [NAT](https://en.wikipedia.org/wiki/Network_address_translation). Tracking companies have to distinguish between all those people - their profiles would be useless otherwise.

Tracking companies have far more advanced methods. One well-known identification method is _Cookies_, little portions of data in your browser or mobile client. However, since Cookies can easily be altered or removed by users, trackers came up with far more advanced technologies like browser fingerprinting and even running behavioral pattern recognition to uniquely identify users. All these things cannot be influenced or altered in any way by a VPN.

If you are worried about these things, then use a browser with integrated tracking protection features. In Firefox, [Multi-Account Containers and the Facebook Container Extension](https://blog.mozilla.org/firefox/facebook-container-extension/) for example help by locking those tracking sites into their isolated sandbox, so they cannot track you when you are not actively using them. The whole “a VPN makes you browse anonymously” thing is just marketing.

### Location leaking

Another very effective method these VPN marketing people are using is showing your location on their sites. This is very effective at scaring people since those sites hit either your actual hometown or a city nearby. Nobody wants to share their location publicly.

“Your IP address” is not leaking your home address.

You see, your modem is not connected to a cable that leads directly to your ISPs main router. Instead, your internet data is _merged together_ with other peoples data on the way. ISPs split up their network into multiple segments to make their network more manageable, and to reduce the amount of cable needed. To have some structure in their networks, they “group” a bunch of customers together, for example by city or by district.

![net-chart](https://user-images.githubusercontent.com/53189968/245770047-1694834b-7ebf-4c4d-9a3b-e995a9a33462.png)

Some of these _merging points_ are passive components, a bit like a USB splitter. Other points are proper routers themselves, and those have IP addresses on their own. Let’s call those points _hops_, as in “your internet packets _hop_ on those points to reach their target”, and multiple hops build the _route_ to the server you want to reach. With utilities like [`traceroute`](https://en.wikipedia.org/wiki/Traceroute) you can check the route to a server yourself. Here, for example, is the route between the server hosting my blog and `google.com`:

```
 1  core12.nbg1.hetzner.com (213.239.229.5)
 2  core0.fra.hetzner.com (213.239.252.25)
 3  72.14.218.176 (72.14.218.176)
 4  108.170.251.193 (108.170.251.193)
 5  72.14.234.227 (72.14.234.227)
 6  fra16s25-in-f14.1e100.net (216.58.207.78)
```

If you are from Germany, you might be able to identify some snippets here. `nbg`, for example, is short for Nuremberg, `fra` is short for Frankfurt. So, as the first hop has Nuremberg in its name, this server is probably located close to - or in - Nuremberg. Also, the Google server I am connecting to is _probably_ in Frankfurt.

Companies like [MaxMind](https://www.maxmind.com/en/locate-my-ip-address) sell large databases that map IP ranges, and the data I showed to you is one of the multiple indications they probably use to build these databases. Ultimately, this means that the location these VPN sites show you is the location of a piece of large network equipment of your ISP, and not your location. Quite often, if you look closely on the maps they show you, the marker ends up just being in the geographical center of a town, sometimes tens if not hundreds of kilometers away, because that is the best they can do to locate “you”.

## “Network Encryption”

The second large topic in VPN advertisements is traffic encryption. They claim that, without VPNs, your personal data is sent unencrypted for everyone to read, while the VPN protects your private data by wrapping it in strong encryption.

Technically, this is not a lie, they indeed _do_ encrypt your network traffic inside the VPN. However, I am fairly confident that most people will overestimate the amount of protection you gain from it, and _where_ the data is actually encrypted. So let’s look into that.

### What a VPN can encrypt, and what it can’t.

In the following few paragraphs, I will write on the assumption that you indeed send out your data unencrypted. We will look into the substance of that assumption in just a bit, but it makes explaining the situation a lot easier, for now.

If you send unencrypted data over the internet, you are essentially sending out a love letter on the back of a postcard. Every node in the chart shown earlier _could_ read and modify the contents. The following charts show the _cables_ and _nodes_ where your content is passed, red means the content is sent unencrypted, green means the content is encrypted.

![net-all-unencrypted](https://user-images.githubusercontent.com/53189968/245770082-bb133b2b-e2c5-4f0b-8011-c8b4b0966713.png)

Okay, this is bad. Everything is red, not a single connection in there is green. And yes, that is _absolutely_ how your data is passed when you send stuff unencrypted, which is why encryption is so important.

So, how does a VPN solve that issue? Well, the thing is, it does not. Remember when I earlier described VPNs as a _tunnel_? Every tunnel needs to end somewhere. For VPNs, you send your data through the encrypted “VPN tunnel” to VPN provider’s servers. But what happens to your data once it arrives there? Well, VPN providers are unable to deliver your data packets directly to the final destination, because they do not actually know where that is. All they can do is to throw your packets back into the public internet so that it eventually can reach its goal. To visualize this, we need to alter our chart slightly.

![net-via-vpn](https://user-images.githubusercontent.com/53189968/245770109-cf2d8848-0adb-4c43-beb9-952469749d82.png)

You might be surprised now, given there is still a lot of red in there. And as sorry as I am, this chart is not an exaggeration in any way.

Remember how I explained the _proper_ use case for VPNs earlier? VPNs were designed to get network traffic _into_ the network they are located, and they are designed to do that in a very secure manner. There is no difference here with commercial VPNs: They get your data to the VPNs endpoint in a secure fashion, and that is about it. As soon as your traffic reached the VPN endpoint, which is a server the VPN provider runs, the data will get decrypted and leave the VPN provider’s network just like it would leave your network if you did not use a VPN. Unencrypted.

This means that as soon as your data leaves the VPN tunnel, everyone can, once again, read and modify your data. This includes the VPN provider itself. The only secured channel here is the route between your machine and the VPN server.

Now, what can _you_ do to get your data encrypted to the target server? Unfortunately, there is nothing you can do. The only way to transmit data encrypted to the end is if the target server is supporting encrypted connections. However, as it turns out, this is _probably_ nothing you actually have to worry about.

### Your data probably is encrypted anyway

Remember the thing about little padlock icons in your browser’s address bar, and the prefix `https://` in front of the domain name?

![https-address-bar](https://user-images.githubusercontent.com/53189968/245770151-980efa46-c360-495b-8448-1788d5b90330.png)

HTTPS is the _secure_ version of HTTP, which is the protocol your browser is using to talk to web servers. HTTPS is using a set of cryptographic protocols called [Transport Layer Security](https://en.wikipedia.org/wiki/Transport_Layer_Security). You do not need to know the details, because they are so complicated that I cannot remember them myself. All you need to know is that whenever there is a padlock and the `https` prefix in your address bar, _your browser_ will encrypt the data in a way that can only be decrypted by the destination server. No matter if you are using a VPN or not, with TLS, your data is encrypted from the start to the end, and the chart would look like this:

![net-tls](https://user-images.githubusercontent.com/53189968/245770171-596b83f4-6fc4-4b86-92d6-cc11c454d866.png)

TLS is not just used in your browser. Your email client? Probably using TLS. Your instant messaging app? Using TLS. Your Twitter client? Using TLS. In modern days, it is really, _really_, rare for an application handling personal data not to use some form of encryption. With projects like [Let’s Encrypt](https://letsencrypt.org/), making TLS certificates free for everyone, there is absolutely no reason for applications not to add encryption, and there is a myriad of reasons why not encrypting is a horrible idea.

I wanted to know _how_ popular TLS is these days. Getting reliable data on all forms of communication is tricky, so I decided to only look at the distribution of HTTP vs. HTTPS. For that, I had to shell out money and get the list of top 3000 domains in the United States via the [Alexa Top Sites web service](https://aws.amazon.com/alexa-top-sites/). I used that list to run some checks[1](https://overengineer.dev/blog/2019/04/08/very-precarious-narrative.html#fn:1) on the sites you are probably using the most, here are the results.

![top3000-chart](https://user-images.githubusercontent.com/53189968/245770186-40bfd7fe-2de4-432d-a914-6ed4b45bad8c.png)

Out of 3000 tested domains, 2906 offered HTTP at the root level. The few others are domains that only get used for subdomains, like CDNs, so I filtered them out. Out of those remaining, 2863 domains did support HTTPS. This means that _98.52%_ of the top 3000 sites are either using HTTPS right away, or are redirecting to another domain that supports HTTPS immediately, meaning your data is encrypted just fine, no matter if you are using an “encrypted VPN” or not.

In conclusion, “make sure there is a lock in your address bar” is much better advice than “use a VPN”.

### What about “DNS leakage”?

Interestingly enough, [“DNS leak”](https://en.wikipedia.org/wiki/DNS_leak) is a term coined and widely popularized by commercial VPN providers. A “DNS leak” happens when your VPN fails to take care of tunneling your DNS requests, resulting in the request being sent to your ISP. Somehow, VPNs have turned them not failing to do their job into something they can market as a special feature. As these VPNs make a really big deal about using your ISP for DNS, let’s talk about what DNS is and the privacy impact of DNS queries.

[DNS](https://en.wikipedia.org/wiki/Domain_Name_System), short for Domain Name System, the system that turns human-readable domain names like `overengineer.dev` or `twitter.com` into something more useful to computers, IP addresses like `159.69.231.132` or `104.244.42.129`. DNS was invented because humans generally have a hard time remembering IP addresses.

Generally speaking, DNS is unencrypted, which means that everyone between you and the DNS server can read your DNS queries. There is nothing too private in there, as the query is basically a simple “Hey, can you tell me the IP for `overengineer.dev`?”, where the server replies with “Sure, the IP is `159.69.231.132` - good luck!”. Usually, your ISP runs your DNS servers, so you do not send this information all over the internet.

This is where the VPN marketeers pick you up, because, in theory, your ISP could keep a list of all domains you requested and based on that, they would have a pretty good understanding of what you were doing online. So VPNs claim to “solve” this issue by offering their own DNS servers, and setting your computer up in a way that uses these servers through the VPN. However, it should be clear by now that this is not resolving the issue because the VPN provider still handles unencrypted DNS requests, and now _they_ could log these requests. With a VPN, all you end up doing is shifting the trust from one party to another. You are not gaining anything.

Instead of just shifting the trust from one ISP to another, some people are working on getting DNS itself encrypted, just like HTTPS. As this story is far too big for me to explain here, please check out [this article on Mozilla Hacks](https://hacks.mozilla.org/2018/05/a-cartoon-intro-to-dns-over-https/) for more details.

## But can using a VPN cause harm?

With all that being said, we have figured out that VPNs really do not add that much to your online privacy. But can using them cause actual harm?

There is no black or white answer here. First of all, using a VPN that is being marked as super secure and super anonymous can easily have some unfortunate side-effects. This false sense of security can lead you to do things that you normally would not do. Additionally, there is a lot of room on the technical side for things to go wrong.

### The “no logs” thing

Almost all of the commercial VPN providers claim they do not collect personal data or your VPN activity. However, the sad reality is, there is no such thing as a “no logs” VPN. Because running it would technically be impossible.

Starting with the obvious, if you pay for a VPN service, they have to keep your user account and associated payment information and your payment history. So, unless you are using a fake identity and an anonymous credit card (is that even possible these days?), your VPN account will be linked to your actual identity.

Most VPNs limit the number of devices that can be connected at the same time. For that to work, well, they have to store a piece of information stating which device is connected, and what VPN account it is associated with. They have to associate your VPN session with your VPN account, as counting the number of sessions per account would be impossible otherwise. There is a lot more data that needs to be stored, at least temporary, to make networking work.

How long do they store this data? Surely it’s only temporary, right? You do not know. Just like you have to _trust_ your ISP that they do not collect data, you have to _trust_ that your VPN provider is not storing the same data. And seriously, what is your reasoning behind trusting an anonymous company from the British Virgin Islands or in Panama more than you trust your ISP, which is a big company with public leadership people and something to lose?

### Using a VPN does not make you anonymous.

As outlined in previous paragraphs, VPNs do absolutely nothing to protect your identity in most cases. As a good example [here](https://www.justice.gov/opa/press-release/file/1001841/download) is a case from a US District Court. The offense in question were serious cases of cyberstalking. The defendant was using a VPN in an attempt to hide their identity, but it turned out to be worthless.

While connected to the VPN, the defendant logged into their personal Google Mail account. This could be a simple mistake by accessing that account, but it could also be that this was just some background service checking the server for new mail. Because of that, their VPN IP (you know, the one that is supposed to “hide” your identity) was directly linked to their identity, and the case was simple.

Regardless if you want to stay anonymous towards other sites, trackers, ISPs, hackers, or governments, a VPN is not doing that job for you.

### Security issues in VPNs and their clients

Just like any piece of software, VPNs and their clients are far from perfect. A [paper published in 2015](http://web.archive.org/web/20190814224309/https://www.degruyter.com/downloadpdf/j/popets.2015.1.issue-1/popets-2015-0006/popets-2015-0006.pdf) concludes that lots of large commercial VPNs clients had significant security issues. These issues ranged from simple DNS leaks to more significant issues like VPNs that did not tunnel IPv6 and forgot to turn it off, and even VPNs that allowed hijacking the user’s DNS configuration. The study also showed that some VPN services did not even run their own DNS servers, but just used Google’s public DNS server, despite claiming “privacy improvements”.

I am not saying that all current VPNs have security issues, especially since the paper was published four years ago and I hope that all these issues have been addressed. However, VPN clients are still software, and contrary to projects like [OpenVPN](https://openvpn.net/), which can be validated by independent security researchers, commercial VPN clients always add their own little touches. And more often than not, these “customizations” are cause for a lot of trouble.

### VPNs are a central point for attackers

The security issues I mentioned are more dangerous if you think what these commercial VPN providers actually are. The big services, especially those with enough money to sponsor tons of YouTubers, handle _tons_ of private information from a lot of different users.

If you were a hacker with malicious intentions, what would you attack? A small instance of someone hosting their private VPN based on open source software; or a large commercial VPN provider, handling the connections for thousands if not hundreds of thousands of users? Yes. Ironically, these VPN providers claiming they want to improve the privacy and security of their customers create _huge_ issues. They centralize a lot of traffic onto a single infrastructure, and suddenly, lots of people depend on a small number of engineers maintaining that central infrastructure to do their job correctly.

Large commercial VPNs are not only interesting to malicious hackers looking for credit cards to sell and private data to use. They also make governmental surveillance easier. Instead of having to listen on each person’s ISP, a government could, in theory, just hijack a large VPN service. This is not a good situation for anyone.

## So, are there valid reasons to use a VPN?

All right. After I spent over 4000 words explaining why VPNs are using deliberate misinformation in their marketing strategies and showing how VPNs do not help your privacy online, this post sounds like I am totally against VPNs. And while I indeed do _dislike_ the current wave of commercial VPN providers, I think there are some valid use-cases, and I think it is important to highlight those as well.

### Accessing private networks

Just as a reminder: This is what VPNs were originally designed for. There is absolutely nothing wrong with using VPNs to gain access to otherwise inaccessible resources. This usually applies to business contexts where companies will use VPNs to grant you access to internal network resources. However, there are other groups using VPNs as well. For example, a non-profit organization could use a VPN to grant its members access to internal-only applications, without the risk of having these systems exposed to the internet.

### Public networks

If you are using your device on a public network, VPNs can help you protect your data. Good examples for such networks are the WiFi networks that do not require a passphrase to connect, for example on Airports, in Cafes, or public buildings. Networks like these make it easy for attackers to get a copy of your network data, and if you send something unencrypted, the results can be quite harmful. Although data is encrypted when you are using HTTPS, and while the same mechanisms should protect you against most attacks, there is always a little risk left that some application you use is using unencrypted data transfer for whatever reason. When it is as easy for other people to sniff your network traffic as it is in a public WiFi, using a VPN is just one less thing to worry about. VPN clients sometimes also have a nice side effect of temporarily disabling file sharing and similar features in your operating system, which is a good thing in public networks.

I have a [ProtonVPN](https://protonvpn.com/) subscription myself, just for those instances where I am sitting in an airport waiting for my plane, or using a large event’s WiFi to check my mail. In those cases, using a VPN is a really smart thing to do, as long as you do not expect your data is more secure than in your home network.

### Geolocked content

Some content on the internet is, unfortunately, locked behind geographic borders. Examples of that may include your favorite news channel livestream, which is unavailable if you are traveling abroad, or some sites that decided it is a good idea to lock everyone inside the European Union out because they are too lazy to comply with EU data protection laws.

In those cases, using a VPN which allows you to select the country you would like to be in can be beneficial. Again, unless you expect your data to be magically protected, this is an awesome use-case for a commercial VPN!

### Circumvention of ISP-level web blocking

Commercial VPNs are not just interesting to people who want to “protect their privacy”. In some countries, or behind some ISPs, certain internet resources can be blocked for technical or political reasons. YouTube, for example, was [blocked in Turkey several times](https://en.wikipedia.org/wiki/Censorship_of_YouTube#Turkey). VPNs _can_ be a way to work around these restrictions, by tunneling your network traffic through a country where those limitations do not apply.

Let me be 100% clear here. VPNs _do not protect you_ and they are not a valid method to circumvent governmental surveillance. If you do use a commercial VPN to do things that are illegal in your country, you put yourself in great danger. I am not kidding.

However, in some cases, the basis of those blocks can be quite… gray, and circumventing the blocks might not directly violate the laws. I am not your lawyer, and I am not giving you any advice. Do your research about your situation if you think this could affect you. However, VPNs could be a way to work around these blocks.

## In the end…

Starting out this article, I quote a [paper published from 2015](http://web.archive.org/web/20190814224309/https://www.degruyter.com/downloadpdf/j/popets.2015.1.issue-1/popets-2015-0006/popets-2015-0006.pdf). To close this, I would like to quote the same sentence once again.

> […] another worrying aspect of today’s market of VPN services is the large misinformation end users are exposed to, which makes it hard for them to properly tell apart vague and bold claims typical of product advertisement campaigns with actual facts.

This quote was written four years ago. Nowadays, we still see popular people advertising commercial VPN services with the same marketing claims and bold promises. Even worse, I feel like these services become more and more popular. This has to stop. We have to get better.

Making people aware of privacy and security topics is amazing. Showing them solutions to those issues is also awesome, but for that to be effective, we - as in the whole internet - have to suggest and rely on methods that actually _do_ what we need them to do. Using a VPN does not protect you against hackers who hijack parts of the internet to read traffic. Using a VPN does not protect you against data breaches on the services you are using. Using a VPN does not automatically protect your privacy and your identity. VPNs are tools you can use to achieve those goals, but you have to know _how_ to use them.

I wrote this article to vent my frustration about popular YouTube education channels promoting VPNs by reading their false marketing lingo out loud. I also wrote this article as a reference to point people towards if they have questions, or to quote from if I have to explain data breaches to people who were using a VPN.

To people currently promoting these services, I have a personal message. I am not asking you to stop accepting money from those services. I do understand that sponsoring is a huge part of the thing that makes your work possible, and I am not the person to tell you where you should get your money from. All I am asking is that you spend a bit of time researching and validating the claims that your sponsors get you to read. I know this is annoying and a lot of work, but you have to do it. People who are far less experienced and knowledgeable than you keep watching your videos. They will hear your advertisement, and they expect you only to say things that you have personally vetted, and they trust you. If you tell them that using a VPN will keep their data safe, they will have false expectations. Let us work on not raising false expectations, and instead, let’s educate people, without relying on marketing material.

If you made it this far, you have successfully finished a 5000+ words article on VPNs. I know this was a long text, but I did not manage to write it any shorter without losing out on accuracy. Thank you so much for working through this. Feel free to validate all of my claims, and share the knowledge you have gained. You _are_ awesome.

## Amendments and Corrections

Since this article blew up in certain parts of the internet, I received more feedback than I could ever individually respond to. So, thank you very much to all of you who took the time to raise questions or provide feedback in a friendly manner. With the feedback I received throughout the day, I made some changes to the article, and I would like to add some additional points.

- An earlier version of this post’s introduction claimed that VPNs “do absolutely nothing” for your privacy. Writing this was a mistake, especially since I contradicted myself later in this article. I reworded the introduction point and expanded the end a bit so that it is clear that VPNs can be used as one of many tools to help your privacy if you know how to use that tool.
- In my list of valid use-cases for VPNs, earlier versions of this article missed the very thing VPNs were initially designed for: accessing private networks and resources within those networks. While I thought this post was clearly only addressing commercial VPNs, I have received multiple messages from people who got concerned about their company’s VPN, for example. I added commercial VPNs as an additional valid use-case, and I am sorry for the confusion this may have caused.
- I received a lot of feedback from North American people explaining they have zero confidence in their ISPs, and some provided me with references of current legislature and previous data collection scandals with large ISPs. Although I used the top 3000 US domain list for my statistic, I am _not_ living in North America, and in most European countries, ISPs acting as US ISPs did would be conducting illegal behavior. Because of that, I may have given that point not enough weight.  
    I am still working through lots of information I received, and since I am not familiar with US contracts and US laws, which will take me a while. What I gathered so far is that while it _is_ legal for ISPs to collect some connection data, they have to provide their customers with legally-binding Opt-Out mechanisms.  
    While it is a terrible situation when you have to Opt-Out first, I need to do more research on this point, because I do not like writing stuff without solid knowledge. Generally speaking, though, I stand by what I wrote earlier: While ISPs might be the easier targets to dislike, they actually do have a lot more to lose than anonymous, overseas VPN companies. This is by no means a resolution to the dilemma of choosing which party you trust the most, but it may be something to keep in mind.
- Some folks raised concerns that while I spend lots of words on explaining why using VPNs can be misleading, I did not provide alternatives to educate people on what they could do instead. This is correct, and although this was a deliberate decision, I do understand the criticism.  
    There are a lot of things I could write about, Tor for example, that actually can be used as a very effective privacy-enhancing tool. However, I started this article with the intention of addressing VPN marketing claims and to explain those in a way that people with little to no technical understanding could grasp. While I would love to explain these alternatives in a similar fashion, doing so would turn this article from a very long text into a _very_ long book. I simply do not have the resources to provide this information.  
    I will, however, continue to collect feedback. If I stumble upon resources explaining these concepts in a complete, yet easy to understand fashion, I will add references here.
- [Drew DeVault wrote a very similar article](https://drewdevault.com/2019/04/19/Your-VPN-is-a-serious-choice.html), mentioning some of the alternatives to commercial VPNs. Readers with some level of technical expertise might find that a good starting point for further research.
- I got approached by a person who wrote an article claiming that VPN review sites are rigged because they use VPNs affiliate programs and thus are mainly interested in maximizing their revenue. [I looked at some numbers](https://overengineer.dev/txt/2019-04-22-vpn-review-neutrality.html) and could not find evidence for that, but I am linking my results anyway in case someone has similar thoughts.
- If you got this far, you should also check out [the 2017 article by Brian Krebs about commercial VPNs](https://krebsonsecurity.com/2017/03/post-fcc-privacy-rules-should-you-vpn/) . I would also like to bring your attention to [this lovely 2017 tweet from @SwiftOnSecurity](https://twitter.com/SwiftOnSecurity/status/854131577353367554). :)