
# gitbiome

Aggregate your online presences with the help of GitHub!

- ✅ **Customization**: Choose how your profile is displayed with various theming options
- ✅ **Responsivity**: Your landing page will look great on any device
- ✅ **Easy setup**: Signing up has never been easier as it is unnecessary with our service
- ✅ **Auto-updated data**: Data is dynamically pulled from your GitHub profile

Check out [our website](https://gitbio.me) to see it yourself.

## Creating your profile

### Prerequisites
You must publish a GitHub repository named **`gitbio`**, that contains the following files:
- `page.json`
- `readme.md` (optional)


Structurally should look like this:
```bash
├── gitbio (repository)
│   ├── page.json
│   ├── readme.md           # optional
```

**⚠️ The file names are case-sensitive!**


### page.json
This file holds your page configuration, but it must follow a defined convention

- **`display_name (string)`**: Displayed above your GitHub username
- **`bio (string)`**
- **`platforms (url[])`**: A collection of your social media
- **`showcased_repos (string[])`**: Max. 3 of your repositories to be displayed
- **`show views (boolean)`**: Whether or not to display the views on your gitbio profile. Default is `true`
- **`theme ('light' | 'dark')`**: Theme of your landing profile. Default value is `dark`
- **`background_color (css color)`**: A blurred circle in the background, colored of your choosing
- **`spotify_ws (url)`**: A websocket application endpoint for providing real-time Spotify data. Learn more [here](https://github.com/csehviktor/now-playing?tab=readme-ov-file#now-playing)


An example:
```json
{
    "display_name": "john doe",
    "bio": "use gitbio.me 😍😘",
    "platforms": [
        "https://instagram.com/therock",
        "https://yoursit.ee/",
        "https://twitter.com/elonmusk",
        "random string" // (will not be shown)
    ],
    "showcased_repos": [
        "gitbio",
        "my-repository",
        "hello world", // (invalid repo name, therefore will not be shown)
    ],
    "show_views": true,
    "theme": "dark",
    "background_color": "#8040ee"
}
```

**Keep in mind!** All of the config keys shown above are optional. Customize your page to your liking.

### readme.md
No strict convention, other than file's name being case-sensitive.

- `README.md` ❌
- `rEaDmE.md` ❌
- `readme.MD` ❌
- `readme.md` ✅

### Your profile

After creating the repository with the corresponding file(s), your profile will be accessible on `gitbio.me/[username]` or `[username].gitbio.me`

**Your gitbio username is equivalent to the one on Github**

## FAQ

### How do I set an avatar and username?

>You can't. Your avatar and username will be equivalent to the ones on GitHub.

### How can I set an icon for my social platform?

>You can't. Icons are automatically loaded from a preset, according to the origin of your url. External urls are provided with an "external website" icon.

### I updated my profile but it won't change on the website. Why?

>Our service uses cache on loaded values in order to improve load time. It might take a minute or two for changes to take place. In case an error occurs while reading data, it will be shown on your profile page.

### How do I delete my profile?

>You simply delete the repository.

### My profile is not working properly in terms of functionality or responsivity. 

>Our service might not be 100%. Issues, pull requests, or even ideas are welcome!

## License
[GPL-3.0](https://github.com/csehviktor/gitbiome/blob/main/license)