#!/bin/bash

# Exit immediately if a command exits with a non-zero status
set -e

# Update package index
sudo apt-get update

# Install required packages for Docker installation
sudo apt-get install -y ca-certificates curl

# Create the directory for Docker's apt keyrings
sudo install -m 0755 -d /etc/apt/keyrings

# Download and add Docker's GPG key
sudo curl -fsSL https://download.docker.com/linux/debian/gpg -o /etc/apt/keyrings/docker.asc

# Set appropriate permissions for the GPG key
sudo chmod a+r /etc/apt/keyrings/docker.asc

# Add Docker's official apt repository
echo \
  "deb [arch=$(dpkg --print-architecture) signed-by=/etc/apt/keyrings/docker.asc] https://download.docker.com/linux/debian \
  $(. /etc/os-release && echo \"$VERSION_CODENAME\") stable" | \
  sudo tee /etc/apt/sources.list.d/docker.list > /dev/null

# Update package index again to include Docker's repository
sudo apt-get update

# Install Docker packages
sudo apt-get install -y docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin

# Add the current user to the Docker group
sudo usermod -aG docker $USER

# Refresh group membership without needing to log out and back in
newgrp docker

# Print success message
echo "Docker has been installed successfully.